onEvent('ponder.tag', event => {
	event.createTag('kubejs:tcon_smeltery', 'tconstruct:smeltery_controller', '匠魂冶炼炉', '冶炼炉', [
		'tconstruct:smeltery_controller',
		'tconstruct:seared_bricks',
		'tconstruct:seared_drain',
		'tconstruct:seared_faucet',
		'tconstruct:seared_basin',
		'tconstruct:seared_table',
		'tconstruct:seared_fuel_tank',
	])
})

onEvent('ponder.registry', event => {
	event.create('tconstruct:smeltery_controller')
		.scene(
			'tconstruct:smeltery',
			'匠魂冶炼炉搭建',
			'kubejs:tcon',
			(scene, util) => {
				// 显示底盘
				scene.showBasePlate()
				scene.idle(20)
				// 显示炉子底部
				scene.world.showSection([2, 1, 2, 4, 1, 4], Direction.DOWN)
				// PonderPalette可以替换为字符串,new Object()可以替换为{},util.select.fromTo直接替换成数组
				scene.idle(20)
				scene.text(60, '§b底部由最大为11x11的\n§b矩形焦黑砖块构成\n§b这里用的是3x3', [3, 1, 3])
				scene.overlay.showOutline('green', {}, [2, 1, 2, 4, 1, 4], 20)

				scene.idle(30)
				// 显示三个部件
				scene.world.showSection([2, 2, 1, 4, 2, 4], Direction.SOUTH)
				// attachKeyFrame表示直接在文字处创建关键帧
				scene.text(35, '第二层任意方向我们依次放上\n§b焦黑储罐\n§b冶炼炉控制器\n§b排液口')
					.attachKeyFrame()
				scene.idle(30)
				scene.overlay.showOutline('blue', {}, [4, 2, 1], 30)
				scene.text(20, '§b焦黑储罐', [3.5, 3.5, 0.5])
					.placeNearTarget()
				scene.idle(30)
				scene.overlay.showOutline('blue', {}, [3, 2, 1], 30)
				scene.text(20, '§b冶炼炉控制器', [2.5, 3.5, 0.5])
					.placeNearTarget()
				scene.idle(30)
				scene.overlay.showOutline('blue', {}, [2, 2, 1], 30)
				scene.text(20, '§b焦黑排液口', [1.5, 3.5, 0.5])
					.placeNearTarget()
				scene.idle(40)

				scene.text(30, '§b剩余的面用焦黑砖块补上\n§b同时将浇筑口也放上')
					.attachKeyFrame()
				// 显示各砖块
				let bricks = [
					[1, 2, 2], [1, 2, 3], [1, 2, 4],
					[2, 2, 5], [3, 2, 5], [4, 2, 5],
					[5, 2, 4], [5, 2, 3]
				]
				for (let brick of bricks) {
					scene.world.showSection(brick, Direction.DOWN)
					scene.idle(5)
				}
				// 最后一个块
				let final = scene.world.showIndependentSection([5, 3, 2], Direction.DOWN)
				// [0, -1, 0]表示向下,最后的参数为0表示马上显示
				scene.world.moveSection(final, [0, -1, 0], 0)
				scene.idle(10)

				// 修改状态
				scene.world.modifyBlocks([2, 2, 1, 3, 2, 1], state => state.with('in_structure', 'true'), true)
				scene.idle(40)

				// 显示浇筑口等
				scene.world.showSection([2, 2, 0], Direction.SOUTH)
				scene.world.showSection([1, 2, 1], Direction.EAST)
				scene.idle(10)
				scene.world.showSection([2, 1, 0], Direction.DOWN)
				scene.world.showSection([1, 1, 1], Direction.DOWN)
				scene.idle(40)

				scene.overlay.showOutline('red', {}, [4, 2, 1], 60)
				scene.text(60, '§c记得给储罐加上燃料哦,熔岩和烈焰血等', [4.5, 2.5, 1.5])
					.placeNearTarget()
				scene.idle(60)

				// 材料储罐,燃料量器
				scene.world.modifyBlock([4, 2, 1], () => 'tconstruct:seared_ingot_tank', true)
				scene.overlay.showOutline('blue', {}, [4, 2, 1], 20)
				scene.text(20, '§a材料储罐', [4.5, 2.5, 1.5])
					.placeNearTarget()
					.attachKeyFrame()
				scene.idle(40)
				scene.world.modifyBlock([4, 2, 1], () => 'tconstruct:seared_fuel_gauge', true)
				scene.overlay.showOutline('red', {}, [4, 2, 1], 20)
				scene.text(20, '§a燃料量器', [4.5, 2.5, 1.5])
					.placeNearTarget()
					.attachKeyFrame()
				scene.idle(40)

				scene.text(40, '§b熔铸炉下个版本吧,先用冶炼炉试试水')
				// 事实上Direction也可以替换为字符串
			})
})